
//scilab 5.5.2 , OS: Ubuntu 14.04
// Spectral Leakage
//Check the result for the following cases
//case(1): fm=10;fs=125;m=1;m=number of cycles
//case(2): fm=10;fs=125;m=2;
//case(3): fm=200;fs=10000;m=2.5;
//case(4): fm=75;fs=250;m=3;

clc;clear;close;
//fm=input('Enter the frequency of the input signal');//message frequency in Hz
//fs=input('Enter the sampling frequency');//sampling frequency in Hz
//m=input('Enter the number of cycles of the input signal');// Number of cycles 
//Case2:No spectral leakage
fm=10;fs=125;m=2;//Oversampling and integer number of cycles
t=0.0001:1/fs:m/fm;
x=3*cos(2*%pi*fm*t);  		//signal
N=(m*fs/fm);                		//should be non-integer to obtain spectral leakage
for k=1:N
 X1(k)=0;
 for n=1:length(x)
  X1(k)=X1(k)+x(n).*exp((-%i).*2.*%pi.*(n-1).*(k-1)./N);
 end
 end
k=0:N-1
f=k*fs/N;       //frequency axis in Hz
figure(1),subplot(221),plot2d3(t,x),xlabel('time'),ylabel('x(n)'),title('No leakage: m=2, f=10 and Fs=125 Hz'),subplot(223),plot2d3(f,abs(X1)),xlabel('freq in Hz'),ylabel('Mag');//Case 3: Spectral leakage
  fm=10;fs=125;m=2.5;//Oversampling and integer number of cycles
t=0.0001:1/fs:m/fm;
x=3*cos(2*%pi*fm*t);  		//signal
N=(m*fs/fm);                		//should be non-integer to obtain spectral leakage
for k=1:N
 X1(k)=0;
 for n=1:length(x)
  X1(k)=X1(k)+x(n).*exp((-%i).*2.*%pi.*(n-1).*(k-1)./N);
 end
 end
k=0:N-1
f=k*fs/N;       //frequency axis in Hz
figure(1),subplot(222),plot2d3(t,x),xlabel('time'),ylabel('x(n)'),title('Spectral leakage: m=2.5, f=10 and Fs=125 Hz'),subplot(224),plot2d3(f,abs(X1)),xlabel('freq in Hz'),ylabel('Mag')
